package jumpstart.max.web.pages.examples.dupes;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.html.BasePage;

public abstract class DuplicateSubmissionPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/dupes/DuplicateSubmissionPage";

	@InjectState("myOrder")
	// myOrder is a session-scoped object - see hivemodule.xml.
	public abstract MyOrder getMyOrder();

	@Asset("context:/images/action-button.png")
	public abstract IAsset getButtonImage();
	
	public void activate() {
		getRequestCycle().activate(this);
	}

	public void doOrder(int orderQuantity) {
		sleep(2000); // Sleep 2 seconds to simulate busy system
		int newQuantity = getMyOrder().getQuantity() + orderQuantity;
		getMyOrder().setQuantity(newQuantity);
		DuplicateSubmissionPage2 nextPage = (DuplicateSubmissionPage2) getRequestCycle().getPage(
				DuplicateSubmissionPage2.PAGE_NAME);
		nextPage.activate();
	}

	public void doRefresh() {
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private void sleep(long duration) {
		try {
			Thread.sleep(duration);
		}
		catch (InterruptedException e) {
		}
	}
}