package jumpstart.max.web.pages.examples.dupes;

import jumpstart.max.web.commons.form.FlowSynchronizer;

import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.event.PageBeginRenderListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.html.BasePage;

/**
 * Base page for pages that must not be accessible if the user is not logged in.
 */
public abstract class TheSynchronizerTokenBasePage extends BasePage implements PageBeginRenderListener {

	@InjectState("flowSynchronizer")
	// flowSynchronizer is a session-scoped object - see hivemodule.xml.
	public abstract FlowSynchronizer getFlowSynchronizer();

	/**
	 * By declaring this field, with "client" persistence, we don't have to code
	 * a hidden field into every form. The "form" strategy saves on client
	 * traffic - see http://wiki.apache.org/tapestry/FormClientPersistence .
	 */
	@Persist("client:form")
	public abstract String getClientFlowToken();
	public abstract void setClientFlowToken(String value);

	/**
	 * This method does 2 things: (1) when rendering the page it gets a fresh
	 * token from the flowSynchronizer and saves it in the client; (2) when
	 * rewinding the page it gets the token from the client and feeds it to the
	 * flowSynchronizer which will decide whether it has seen it before. Its
	 * decision can be checked with the isResubmission() method.
	 */
	public void pageBeginRender(PageEvent evt) {

		// If rewinding (ie. handling input from the client),
		// - give the token from the client to the synchronizer to inspect

		if (getRequestCycle().isRewinding()) {
			getFlowSynchronizer().setToken(getClientFlowToken());
		}

		// else rendering (ie. creating output to the client),
		// - get a fresh token from the synchronizer and save it in the client

		else {
			setClientFlowToken(getFlowSynchronizer().getToken());
		}
	}

	//
	// Flow Synchronization.
	// The getter and setter are used by code like this in the forms of your
	// html templates:
	// <input jwcid="@Hidden" value="ognl:flowToken"/>
	// The other 2 methods are used in java - in your page's listener methods.
	// See the FlowSynchronizer source for more information.
	//

	public String getFlowToken() {
		return getFlowSynchronizer().getToken();
	}

	public void setFlowToken(String flowToken) {
		getFlowSynchronizer().setToken(flowToken);
	}

	protected boolean isResubmission() {
		// check if this cycle is a resubmission (before doing inserts etc)
		return getFlowSynchronizer().isResubmission();
	}

	//
	// WARNING: This method can cause problems when running with
	// disable-caching=true (which you would not do in production). Symptom is
	// exceptions about annotations.
	// See https://issues.apache.org/jira/browse/TAPESTRY-696
	//
	protected void preventResubmission() {
		if (isResubmission()) {
			throw new PageRedirectException(TheSynchronizerTokenExceptionPage.PAGE_NAME);
		}
	}
}
