package jumpstart.max.web.pages.examples.dupes;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.InjectState;

public abstract class TheSynchronizerTokenPage extends TheSynchronizerTokenBasePage {
	static public final String PAGE_NAME = "pages/examples/dupes/TheSynchronizerTokenPage";

	@InjectState("myOrder")
	// myOrder is a session-scoped object - see hivemodule.xml.
	public abstract MyOrder getMyOrder();

	@Asset("context:/images/action-button.png")
	public abstract IAsset getButtonImage();

	public void activate() {
		getRequestCycle().activate(this);
	}

	// Order widgets - except if resubmission then ignore the request and
	// redisplay page
	public void doOrderIgnore(int orderQuantity) {
		if (!isResubmission()) { // Ignore resubmission
			sleep(2000); // Sleep 2 seconds to simulate busy system
			int newQuantity = getMyOrder().getQuantity() + orderQuantity;
			getMyOrder().setQuantity(newQuantity);
			TheSynchronizerTokenPage2 nextPage = (TheSynchronizerTokenPage2) getRequestCycle().getPage(
					TheSynchronizerTokenPage2.PAGE_NAME);
			nextPage.activate();
		}
	}

	// Refresh page - except if resubmission then ignore the request and
	// redisplay page
	public void doRefreshIgnore() {
		if (!isResubmission()) {
			// No action is required to refresh this page!
		}
	}

	// Order widgets - except if resubmission then prevent it and go to error
	// page
	public void doOrderPrevent(int orderQuantity) {
		preventResubmission();
		sleep(2000); // Sleep 2 seconds to simulate busy system
		int newQuantity = getMyOrder().getQuantity() + orderQuantity;
		getMyOrder().setQuantity(newQuantity);
		TheSynchronizerTokenPage2 nextPage = (TheSynchronizerTokenPage2) getRequestCycle().getPage(
				TheSynchronizerTokenPage2.PAGE_NAME);
		nextPage.activate();
	}

	// Refresh page - except if resubmission then prevent it and go to error
	// page
	public void doRefreshPrevent() {
		preventResubmission();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private void sleep(long duration) {
		try {
			Thread.sleep(duration);
		}
		catch (InterruptedException e) {
		}
	}
}