package jumpstart.max.web.pages.examples.infrastructure;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.html.BasePage;

public abstract class EngineServicesAndRestartPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/infrastructure/EngineServicesAndRestartPage";

	@Asset("context:/images/action-button.png")
	public abstract IAsset getActionButton();

	@Asset("context:/css/examples_engine.css")
	public abstract IAsset getStylesheet();

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	public void doToFriendlyURLs() {
		FriendlyURLsPage nextPage = (FriendlyURLsPage) getRequestCycle().getPage(FriendlyURLsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToPage2() {
		EngineServicesAndRestartPage2 nextPage = (EngineServicesAndRestartPage2) getRequestCycle().getPage(
				EngineServicesAndRestartPage2.PAGE_NAME);
		nextPage.activate();
	}

	public void doToPage3() {
		EngineServicesAndRestartPage3 nextPage = (EngineServicesAndRestartPage3) getRequestCycle().getPage(
				EngineServicesAndRestartPage3.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}