package jumpstart.max.web.pages.examples.infrastructure;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.html.BasePage;

public abstract class FriendlyURLsPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/infrastructure/FriendlyURLsPage";

	@Asset("context:/images/action-button.png")
	public abstract IAsset getActionButton();

	@Asset("context:/css/examples_engine.css")
	public abstract IAsset getStylesheet();

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	public void doToEngineServices() {
		EngineServicesAndRestartPage nextPage = (EngineServicesAndRestartPage) getRequestCycle().getPage(
				EngineServicesAndRestartPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToPage2() {
		FriendlyURLsPage2 nextPage = (FriendlyURLsPage2) getRequestCycle().getPage(FriendlyURLsPage2.PAGE_NAME);
		nextPage.activate();
	}

	public void doToPage3() {
		FriendlyURLsPage3 nextPage = (FriendlyURLsPage3) getRequestCycle().getPage(FriendlyURLsPage3.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}