package jumpstart.max.web.pages.examples.jodatime;

import java.util.Locale;

import jumpstart.max.business.domain.examples.DateStuff;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.BusinessServicesLocator;

import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class JodaTimePage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/jodatime/JodaTimePage";

	@InjectState("businessServicesLocator")
	public abstract BusinessServicesLocator getBusinessServicesLocator();

	@Persist
	public abstract void setDateStuff(DateStuff value);

	@Persist
	public abstract void setFrench(DateTimeFormatter value);
	
	@Persist
	public abstract void setISODate(DateTimeFormatter value);

	public void activate() {

		// Ask business service to find DateStuff with id = 1.

		DateStuff dateStuff = getExamplesService().findDateStuff(new Long(1));

		if (dateStuff == null) {
			throw new IllegalStateException("Database data has not been set up!");
		}

		// Populate the page and flag it as the next one to activate

		setDateStuff(dateStuff);
		setFrench(DateTimeFormat.fullDate().withLocale(Locale.FRENCH));
		setISODate(ISODateTimeFormat.date());
		getRequestCycle().activate(this);
	}

	public void doEdit(Long dateStuffId) {
		JodaTimePage2 nextPage = (JodaTimePage2) getRequestCycle().getPage(JodaTimePage2.PAGE_NAME);
		nextPage.activate(dateStuffId);
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private IExamplesServiceLocal getExamplesService() {

		// Use our business services locator to get the EJB3 session bean called
		// "ExamplesServiceLocal".
		
		return getBusinessServicesLocator().getExamplesServiceLocal();
	}
}