package jumpstart.max.web.pages.examples.jodatime;

import jumpstart.max.business.domain.examples.DateStuff;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.web.commons.translator.DateMidnightTranslator;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.BusinessServicesLocator;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class JodaTimePage2 extends BasePage {
	static public final String PAGE_NAME = "pages/examples/jodatime/JodaTimePage2";

	@InjectState("businessServicesLocator")
	public abstract BusinessServicesLocator getBusinessServicesLocator();

	@Asset("context:/css/examples_client_val.css")
	public abstract IAsset getStylesheet();

	@Persist
	public abstract DateStuff getDateStuff();
	public abstract void setDateStuff(DateStuff value);

	@Bean
	// Beans get created and destroyed on the fly per request cycle
	public abstract ValidationDelegate getValidationDelegate();
	
	@Persist
	public abstract void setMyDateMidnightTranslator(DateMidnightTranslator value);

	public void activate(Long dateStuffId) {

		// Ask business service to find DateStuff with id = 1.
		
		DateStuff dateStuff = getExamplesService().findDateStuff(dateStuffId);

		if (dateStuff == null) {
			throw new IllegalStateException("Database data has not been set up!");
		}

		// Populate the page and flag it as the next one to activate
		
		setDateStuff(dateStuff);
		DateMidnightTranslator translator = new DateMidnightTranslator();
		translator.setPattern("dd/MM/yyyy");
		setMyDateMidnightTranslator(translator);
		getRequestCycle().activate(this);
	}

	public void doSave() {
		getExamplesService().changeDateStuff(getDateStuff());

		JodaTimePage nextPage = (JodaTimePage) getRequestCycle().getPage(JodaTimePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doCancel() {
		JodaTimePage nextPage = (JodaTimePage) getRequestCycle().getPage(JodaTimePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private IExamplesServiceLocal getExamplesService() {

		// Use our business services locator to get the EJB3 session bean called
		// "ExamplesServiceLocal".
		
		return getBusinessServicesLocator().getExamplesServiceLocal();
	}
}