package jumpstart.max.web.pages.examples.localization;

import java.util.Locale;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.html.BasePage;

public abstract class LocalizationByLocalizedTemplatePage2 extends BasePage {
	static public final String PAGE_NAME = "pages/examples/localization/LocalizationByLocalizedTemplatePage2";

	@Asset("context:/css/examples.css")
	public abstract IAsset getStylesheet();

	public void activate() {
		getRequestCycle().activate(this);
	}

	public void doDefault1() {
		activatePage1(Locale.getDefault());
	}

	public void doEnglishUK1() {
		activatePage1(Locale.UK);
	}

	public void doEnglishUS1() {
		activatePage1(Locale.US);
	}

	public void doFrench1() {
		activatePage1(Locale.FRANCE);
	}

	public void activatePage1(Locale nextLocale) {
		getEngine().setLocale(nextLocale);
		LocalizationByLocalizedTemplatePage nextPage = (LocalizationByLocalizedTemplatePage) getRequestCycle().getPage(
				LocalizationByLocalizedTemplatePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}