package jumpstart.max.web.pages.examples.localization;

import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.html.BasePage;

public abstract class LocalizationByMessageCatalogPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/localization/LocalizationByMessageCatalogPage";

	@Asset("context:/css/examples.css")
	public abstract IAsset getStylesheet();

	public abstract void setLocale(Locale value);
	public abstract void setAccount(Account value);

	public Format getMyDateFormat() {
		if (myDateFormat == null) {
			myDateFormat = DateFormat.getDateInstance(DateFormat.LONG, getLocale());
		}
		return myDateFormat;
	}

	private Format myDateFormat;

	public void activate() {
		setLocale(getEngine().getLocale());

		Account myAccount = new Account();
		myAccount.setAccountName("Savings");
		myAccount.setStartDate(createDate(2007, Calendar.MARCH, 30));

		setAccount(myAccount);
		getRequestCycle().activate(this);
	}

	public void doLocale() {
		LocalizationByMessageCatalogPage2 nextPage = (LocalizationByMessageCatalogPage2) getRequestCycle().getPage(LocalizationByMessageCatalogPage2.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	public Date createDate(int year, int month, int day) {
		Calendar cal = Calendar.getInstance();
		cal.set(year, month, day);
		return cal.getTime();
	}
}