package jumpstart.max.web.pages.examples.localization;

import java.util.Locale;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.html.BasePage;

public abstract class LocalizationByMessageCatalogPage2 extends BasePage {
	static public final String PAGE_NAME = "pages/examples/localization/LocalizationByMessageCatalogPage2";

	@Asset("context:/css/examples.css")
	public abstract IAsset getStylesheet();

	public void activate() {
		getRequestCycle().activate(this);
	}

	public void doDefault1() {
		activatePage1(Locale.getDefault());
	}

	public void doEnglishUK1() {
		activatePage1(Locale.UK);
	}

	public void doEnglishUS1() {
		activatePage1(Locale.US);
	}

	public void doFrench1() {
		activatePage1(Locale.FRANCE);
	}

	public void activatePage1(Locale nextLocale) {
		getEngine().setLocale(nextLocale);
		LocalizationByMessageCatalogPage nextPage = (LocalizationByMessageCatalogPage) getRequestCycle().getPage(LocalizationByMessageCatalogPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}