package jumpstart.max.web.pages.examples.returns;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class RestoreFromSessionPage2 extends BasePage {
	static public final String PAGE_NAME = "pages/examples/returns/RestoreFromSessionPage2";

	@Persist("session")
	// Actually, just @Persist would do, because "session" is the default strategy
	public abstract String getFirstName();
	public abstract void setFirstName(String value);

	@Persist("session")
	// Actually, just @Persist would do, because "session" is the default strategy
	public abstract String getLastName();
	public abstract void setLastName(String value);

	public void activate() {
		setFirstName("");
		setLastName("");
		getRequestCycle().activate(this);
	}

	public void activateWithRestore() {
		// The fields will be restored automatically because they are annotated with @Persist("session")
		getRequestCycle().activate(this);
	}

	public void doNext() {
		RestoreFromSessionPage3 nextPage = (RestoreFromSessionPage3) getRequestCycle().getPage(
				RestoreFromSessionPage3.PAGE_NAME);
		nextPage.activate();
	}

	public void doReturn() {
		RestoreFromSessionPage nextPage = (RestoreFromSessionPage) getRequestCycle().getPage(
				RestoreFromSessionPage.PAGE_NAME);
		nextPage.activateWithRestore();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}