package jumpstart.max.web.pages.examples.returns;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.callback.ExternalCallback;

public abstract class ReturnAnywhereUCPPage extends ReturnAnywhereUCPBasePage implements IExternalPage {
	static public final String PAGE_NAME = "pages/examples/returns/ReturnAnywhereUCPPage";

	public abstract String getFirstName();
	public abstract void setFirstName(String value);

	public abstract String getLastName();
	public abstract void setLastName(String value);

	public void activate() {
		clearCallbacks();
		getRequestCycle().activate(this);
	}

	// Used by callback from next page
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		setFirstName((String) parameters[0]);
		setLastName((String) parameters[1]);
		getRequestCycle().activate(this);
	}

	public void doSaveAndGoToPage2() {
		pushCallback(new ExternalCallback(this, new Object[] { getFirstName(), getLastName() }));

		ReturnAnywhereUCPPage2 nextPage = (ReturnAnywhereUCPPage2) getRequestCycle().getPage(ReturnAnywhereUCPPage2.PAGE_NAME);
		nextPage.activate();
	}

	public void doSaveAndGoToPage3() {
		pushCallback(new ExternalCallback(this, new Object[] { getFirstName(), getLastName() }));

		ReturnAnywhereUCPPage3 nextPage = (ReturnAnywhereUCPPage3) getRequestCycle().getPage(ReturnAnywhereUCPPage3.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}