package jumpstart.max.web.pages.examples.returns;

import java.util.EmptyStackException;
import java.util.Stack;

import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.callback.ICallback;
import org.apache.tapestry.html.BasePage;

/**
 * Returnable Base Page, Using a Hidden Field.
 * 
 * Depends on you adding this line to the form in the page's HTML template:
 * 
 * <input jwcid="@Hidden" value="ognl:callbacksStack"/>
 */
public abstract class ReturnAnywhereUHFBasePage extends BasePage {

	/**
	 * callbacksStack is a session-scoped object - see hivemodule.xml.
	 */
	@InjectState("callbacksStack")
	public abstract Stack<ICallback> getCallbacksStack();
	public abstract void setCallbacksStack(Stack<ICallback> value);

	/**
	 * Clear the callback stack.
	 */
	protected void clearCallbacks() {
		getCallbacksStack().clear();
	}

	/**
	 * Push a page's callback info onto the stack so we can return to it later
	 */
	protected void pushCallback(ICallback callback) {
		getCallbacksStack().push(callback);
	}

	/**
	 * Pop the last page's callback info off the stack and activate the page.
	 * Typically used to return to the previous page on Cancel or OK.
	 */
	protected void popAndActivateCallback() {
		ICallback callback = popCallback();
		if (callback != null) {
			callback.performCallback(getPage().getRequestCycle());
		}
	}

	/**
	 * Pop the last page's callback info off the stack.
	 */
	private ICallback popCallback() {
		try {
			ICallback callback = (ICallback) getCallbacksStack().pop();
			return callback;
		}
		catch (EmptyStackException e) {
			return null;
		}
	}
}