package jumpstart.max.web.pages.examples.returns;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.html.BasePage;

public abstract class SimpleRestoreOnReturnPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/returns/SimpleRestoreOnReturnPage";

	public abstract String getFirstName();
	public abstract void setFirstName(String value);

	public abstract String getLastName();
	public abstract void setLastName(String value);

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	// Page 2 calls this method to restore and activate me
	public void activate(String firstName, String lastName) {
		setFirstName(firstName);
		setLastName(lastName);
		getRequestCycle().activate(this);
	}

	public void doDisplay() {
		SimpleRestoreOnReturnPage2 nextPage = (SimpleRestoreOnReturnPage2) getRequestCycle().getPage(
				SimpleRestoreOnReturnPage2.PAGE_NAME);
		nextPage.activate(getFirstName(), getLastName());
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}