package jumpstart.max.web.pages.examples.returns;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class SimpleRestoreOnReturnPage2 extends BasePage {
	static public final String PAGE_NAME = "pages/examples/returns/SimpleRestoreOnReturnPage2";


	@Persist("client")
	// Must persist this field else we'll lose its value because it's output-only
	public abstract String getFirstName();
	public abstract void setFirstName(String value);

	@Persist("client")
	// Must persist this field else we'll lose its value because it's output-only
	public abstract String getLastName();
	public abstract void setLastName(String value);

	// firstName and lastName must not be null
	public void activate(String firstName, String lastName) {
		setFirstName(firstName);
		setLastName(lastName);
		getRequestCycle().activate(this);
	}

	public void doReturn() {
		SimpleRestoreOnReturnPage nextPage = (SimpleRestoreOnReturnPage) getRequestCycle().getPage(
				SimpleRestoreOnReturnPage.PAGE_NAME);
		nextPage.activate(getFirstName(), getLastName());
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}