package jumpstart.max.web.pages.examples.simple;

import jumpstart.max.business.domain.examples.Person;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.BusinessServicesLocator;

import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class SimpleEditPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/simple/SimpleEditPage";

	public abstract void setErrorMessage(String value);

	@Persist
	// We say Persist to tell Tapestry this isn't transient - we want it to
	// remember the entire Person object between output and input
	public abstract Person getPerson();
	public abstract void setPerson(Person value);

	@InjectState("businessServicesLocator")
	// businessServicesLocator locates our business services (which are EJB3 session
	// beans). It is an application-scoped object registered in hivemodule.xml.
	public abstract BusinessServicesLocator getBusinessServicesLocator();

	public void activate(Long personId) {

		// Ask business service to find the Person requested

		Person person = getExamplesService().findPerson(personId);
		if (person == null) {
			throw new IllegalStateException("Database data has not been set up!");
		}

		// Populate the page and flag it as the next one to activate

		setPerson(person);
		getRequestCycle().activate(this);
	}

	public void doSaveAndDisplay() {
		try {
			getExamplesService().changePerson(getPerson());

			SimpleEditPage2 nextPage = (SimpleEditPage2) getRequestCycle().getPage(SimpleEditPage2.PAGE_NAME);
			nextPage.activate(getPerson().getId());
		}
		catch (Exception e) {
			setErrorMessage(getRootCause(e));
			return;
		}
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	private IExamplesServiceLocal getExamplesService() {

		// Use our business services locator to get the EJB3 session bean called
		// "ExamplesServiceLocal".
		
		IExamplesServiceLocal svc = getBusinessServicesLocator().getExamplesServiceLocal();
		return svc;
	}

	private String getRootCause(Throwable t) {
		Throwable cause = t;
		Throwable subCause = cause.getCause();
		while (subCause != null && !subCause.equals(cause)) {
			cause = subCause;
			subCause = cause.getCause();
		}
		return cause.getMessage();
	}
}