package jumpstart.max.web.pages.examples.simple;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.html.BasePage;

public abstract class SimpleInputPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/simple/SimpleInputPage";

	public abstract String getFirstName();
	public abstract String getLastName();

	public void activate() {
		// This simple page requires no preparation before activation.
		getRequestCycle().activate(this);
	}

	public void doDisplay() {
		SimpleInputPage2 nextPage = (SimpleInputPage2) getRequestCycle().getPage(SimpleInputPage2.PAGE_NAME);
		nextPage.activate(getFirstName(), getLastName());
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}