package jumpstart.max.web.pages.examples.simple;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.event.PageBeginRenderListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.html.BasePage;

public abstract class SimpleOutputPage extends BasePage implements PageBeginRenderListener {
	static public final String PAGE_NAME = "pages/examples/simple/SimpleOutputPage";

	public abstract void setMessage(String value);

	public void pageBeginRender(PageEvent arg0) {

		// If rewinding (ie. handling input from the client),
		// - nothing to do.
		// Else rendering (ie. creating output to the client),
		// - set up the message

		if (getRequestCycle().isRewinding()) {
			// Nothing to do.
		}
		else {
			setMessage("Hi!  This message was set up in the pageBeginRender() method.");
		}
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}