package jumpstart.max.web.pages.examples.simple;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.html.BasePage;

public abstract class SimpleValidationPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/simple/SimpleValidationPage";

	public abstract String getFirstName();
	public abstract String getLastName();
	public abstract void setErrorMessage(String value);

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	public void doDisplay() {
		String firstName = getFirstName();
		String lastName = getLastName();

		// Validate your name - error if it's empty

		if (firstName == null || firstName.equals("")) {
			setErrorMessage("First name is required.");
			return;
		}

		if (lastName == null || lastName.equals("")) {
			setErrorMessage("Last name is required.");
			return;
		}

		SimpleValidationPage2 nextPage = (SimpleValidationPage2) getRequestCycle().getPage(
				SimpleValidationPage2.PAGE_NAME);
		nextPage.activate(firstName, lastName);
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}