package jumpstart.max.web.pages.examples.styling;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.html.BasePage;

public abstract class CSSPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/styling/CSSPage";

	@Asset("context:/css/examples.css")
	public abstract IAsset getStylesheet();

	public abstract String getFirstName();
	public abstract String getLastName();

	public void activate() {
		// This simple page requires no preparation before activation.
		getRequestCycle().activate(this);
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}
