package jumpstart.max.web.pages.examples.styling;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.html.BasePage;

public abstract class SwitchableStylePage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/styling/SwitchableStylePage";

	@Asset("context:/css/examples.css")
	public abstract IAsset getStylesheet1();

	@Asset("context:/css/examples2.css")
	public abstract IAsset getStylesheet2();

	@Persist("client:form")
	public abstract int getStyleNum();
	public abstract void setStyleNum(int value);

	public abstract String getFirstName();
	public abstract String getLastName();

	public void activate() {
		setStyleNum(1);
		getRequestCycle().activate(this);
	}

	public IAsset getStylesheet() {

		switch (getStyleNum()) {
		case 1:
			return getStylesheet1();
		case 2:
			return getStylesheet2();
		default:
			return getStylesheet1();
		}

	}
	
	public void doSwitch() {
		int styleNum = getStyleNum();
		styleNum = styleNum < 2 ? styleNum + 1 : 1;
		setStyleNum(styleNum);
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}