package jumpstart.max.web.pages.examples.tables;

import java.util.List;

import jumpstart.max.business.domain.examples.Person;
import jumpstart.max.business.domain.examples.iface.IExamplesServiceLocal;
import jumpstart.max.web.pages.login.LoginPage;
import jumpstart.max.web.state.BusinessServicesLocator;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.InjectState;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.html.BasePage;

public abstract class AlternatingTableComponentPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/tables/AlternatingTableComponentPage";

	@Asset("context:/css/examples.css")
	public abstract IAsset getStylesheet();

	@InjectState("businessServicesLocator")
	public abstract BusinessServicesLocator getBusinessServicesLocator();

	@Bean
	// Beans get created and destroyed on the fly per request cycle
	public abstract EvenOdd getEvenOdd();

	@Persist
	// This is the data source for the Table and it must be persistent or you'll
	// get errors when using the table's page selector.
	public abstract void setPersons(List<Person> value);

	public abstract void setPerson(Person value);

	public void activate() {
		// Get all persons - ask business service to find them (from the database)
		IExamplesServiceLocal examplesService = getBusinessServicesLocator().getExamplesServiceLocal();
		List<Person> l = examplesService.findPersons();
		setPersons(l);

		getRequestCycle().activate(this);
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}
