package jumpstart.max.web.pages.examples.validators;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class MixedValidationPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/validators/MixedValidationPage";

	@Bean
	// Beans get created and destroyed on the fly per request cycle
	public abstract ValidationDelegate getValidationDelegate();

	public abstract String getFirstName();
	public abstract String getLastName();

	@Asset("context:/css/examples_client_val.css")
	public abstract IAsset getStylesheet();

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	public void doDisplay() {

		// If the page's validators detected an error then return.
		// - this is good practice even when client-side validation is enabled
		// just in case a validator doesn't have a client-side implementation,
		// or for any reason client-side validation isn't working or enabled.

		if (getValidationDelegate().getHasErrors()) {
			return;
		}

		// Validate your names further - error if they don't contain letters
		// only

		if (!getFirstName().matches("[A-Za-z]+")) {
			recordError("firstName", "First Name must contain letters only");
			return;
		}

		if (!getLastName().matches("[A-Za-z]+")) {
			recordError("lastName", "Last Name must contain letters only");
			return;
		}

		MixedValidationPage2 nextPage = (MixedValidationPage2) getRequestCycle()
				.getPage(MixedValidationPage2.PAGE_NAME);
		nextPage.activate(getFirstName(), getLastName());
	}

	protected void recordError(String fieldName, String message) {
		ValidationDelegate delegate = getValidationDelegate();
		delegate.setFormComponent((IFormComponent) getComponent(fieldName));
		delegate.record(message, null);
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}
