package jumpstart.max.web.pages.examples.validators;

import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class ValidatorsWithFieldLabelsPage extends BasePage {
	static public final String PAGE_NAME = "pages/examples/validators/ValidatorsWithFieldLabelsPage";

	@Bean
	// Beans get created and destroyed on the fly per request cycle
	public abstract ValidationDelegate getValidationDelegate();

	public abstract String getFirstName();
	public abstract String getLastName();

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	public void doDisplay() {

		// If the page's validators detected an error then return.

		if (getValidationDelegate().getHasErrors()) {
			return;
		}

		ValidatorsWithFieldLabelsPage2 nextPage = (ValidatorsWithFieldLabelsPage2) getRequestCycle().getPage(
				ValidatorsWithFieldLabelsPage2.PAGE_NAME);
		nextPage.activate(getFirstName(), getLastName());
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}
}