package jumpstart.max.web.pages.examples.webflow;

import java.io.Serializable;

// In the real world we'd typically make this a business domain entity 
//@Entity
@SuppressWarnings("serial")
public class CreditApplication implements Serializable {
	
	private int amount = 0;
	private boolean jointApplicants = false;
	private String applicant1Name;
	private String applicant2Name;

	public void validateBasics() throws Exception {
		if (amount < 10 || amount > 9999) {
			throw new Exception("Amount must be between 10 and 9999.");
		}
	}

	public void validateApplicant1() throws Exception {
		if (applicant1Name == null || applicant1Name.trim().equals("")) {
			throw new Exception("Applicant 1 name is required.");
		}
	}

	public void validateApplicant2() throws Exception {
		if (jointApplicants) {
			if (applicant2Name == null || applicant2Name.trim().equals("")) {
				throw new Exception("Applicant 2 name is required on joint applicant applications.");
			}
		}
		else {
			if (applicant2Name != null && !applicant2Name.trim().equals("")) {
				throw new Exception("Applicant 2 name is not allowed on single applicant applications.");
			}
		}
	}
	
	public void validate() throws Exception {
		validateBasics();
		validateApplicant1();
		validateApplicant2();
	}
	
	public int getAmount() {
		return amount;
	}

	public void setAmount(int amount) {
		this.amount = amount;
	}

	public String getApplicant1Name() {
		return applicant1Name;
	}

	public void setApplicant1Name(String applicant1Name) {
		this.applicant1Name = applicant1Name;
	}

	public String getApplicant2Name() {
		return applicant2Name;
	}

	public void setApplicant2Name(String applicant2Name) {
		this.applicant2Name = applicant2Name;
	}

	public boolean isJointApplicants() {
		return jointApplicants;
	}

	public void setJointApplicants(boolean jointApplicants) {
		this.jointApplicants = jointApplicants;
	}

}
