package jumpstart.max.web.pages.examples.webflow;

import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.engine.ILink;

public abstract class WebFlow2Applicant2Page extends WebFlow2BasePage {
	static public final String PAGE_NAME = "pages/examples/webflow/WebFlow2Applicant2Page";

	@Override
	// Beans get created and destroyed on the fly per request cycle
	// Our own validation delegate class allows us to set the focus field!
	@Bean(initializer = "defaultFocusField=name")
	public abstract WebFlowValidationDelegate getValidationDelegate();

	public ILink doNext() {
		ILink redirectTo = null;
		try {
			getCreditApplication().validateApplicant2();
			redirectTo = getNextLink();
		}
		catch (Exception e) {
			recordError(e.getMessage(), "name");
		}
		return redirectTo;
	}

}