// WebFlow2BasePage.java
// The superclass of all pages in this example web flow.  
// Its principal roles are to hold the state object, CreditApplication, and to make the navigation decisions.

package jumpstart.max.web.pages.examples.webflow;

import jumpstart.max.web.commons.annotations.InjectExternalLink;
import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class WebFlow2BasePage extends BasePage implements IExternalPage {

	@Persist("client:form")
	public abstract CreditApplication getCreditApplication();
	public abstract void setCreditApplication(CreditApplication value);

	@InjectExternalLink(WebFlow2StartPage.PAGE_NAME)
	public abstract ILink getWebFlow2StartPageLink(CreditApplication app);

	@InjectExternalLink(WebFlow2Applicant1Page.PAGE_NAME)
	public abstract ILink getWebFlow2Applicant1PageLink(CreditApplication app);

	@InjectExternalLink(WebFlow2Applicant2Page.PAGE_NAME)
	public abstract ILink getWebFlow2Applicant2PageLink(CreditApplication app);

	@InjectExternalLink(WebFlow2FinishPage.PAGE_NAME)
	public abstract ILink getWebFlow2FinishPageLink(CreditApplication app);

	@InjectExternalLink(WebFlow2ResultPage.PAGE_NAME)
	public abstract ILink getWebFlow2ResultPageLink(CreditApplication app);

	@Asset("context:/css/examples_webflow.css")
	public abstract IAsset getStylesheet();

	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		CreditApplication app = (CreditApplication) parameters[0];
		setCreditApplication(app);
		getRequestCycle().activate(this);
	}

	protected ILink getNextLink() {
		ILink nextPageLink = null;
		CreditApplication creditApplication = getCreditApplication();

		if (this instanceof WebFlow2StartPage) {
			nextPageLink = getWebFlow2Applicant1PageLink(creditApplication);
		}
		else if (this instanceof WebFlow2Applicant1Page) {
			if (creditApplication.isJointApplicants()) {
				nextPageLink = getWebFlow2Applicant2PageLink(creditApplication);
			}
			else {
				nextPageLink = getWebFlow2FinishPageLink(creditApplication);
			}
		}
		else if (this instanceof WebFlow2Applicant2Page) {
			nextPageLink = getWebFlow2FinishPageLink(creditApplication);
		}
		else if (this instanceof WebFlow2FinishPage) {
			nextPageLink = getWebFlow2ResultPageLink(creditApplication);
		}
		else {
			throw new IllegalStateException("Page type not expected.  Found " + this.getClass().getName());
		}

		return nextPageLink;
	}

	public ILink doPrev() {
		getValidationDelegate().clear();

		ILink prevPageLink = null;
		CreditApplication creditApplication = getCreditApplication();

		if (this instanceof WebFlow2Applicant1Page) {
			prevPageLink = getWebFlow2StartPageLink(creditApplication);
		}
		else if (this instanceof WebFlow2Applicant2Page) {
			prevPageLink = getWebFlow2Applicant1PageLink(creditApplication);
		}
		else if (this instanceof WebFlow2FinishPage) {
			if (creditApplication.isJointApplicants()) {
				prevPageLink = getWebFlow2Applicant2PageLink(creditApplication);
			}
			else {
				prevPageLink = getWebFlow2Applicant1PageLink(creditApplication);
			}
		}
		else {
			throw new IllegalStateException("Page type not expected.  Found " + this.getClass().getName());
		}

		return prevPageLink;
	}

	public ILink doToStart() {
		return getWebFlow2StartPageLink(getCreditApplication());
	}

	public ILink doToApplicant1() {
		return getWebFlow2Applicant1PageLink(getCreditApplication());
	}

	public ILink doToApplicant2() {
		return getWebFlow2Applicant2PageLink(getCreditApplication());
	}

	public ILink doToFinish() {
		return getWebFlow2FinishPageLink(getCreditApplication());
	}

	public void doToStartAgain() {
		WebFlow2StartPage nextPage = (WebFlow2StartPage) getRequestCycle().getPage(WebFlow2StartPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	protected void recordError(String message) {
		ValidationDelegate delegate = getValidationDelegate();
		delegate.setFormComponent(null);
		delegate.record(message, null);
	}

	protected void recordError(String message, String fieldName) {
		ValidationDelegate delegate = getValidationDelegate();
		delegate.setFormComponent((IFormComponent) getComponent(fieldName));
		delegate.record(message, null);
	}

	protected boolean hasErrors() {
		boolean hasErrors = getValidationDelegate().getHasErrors();
		return hasErrors;
	}
	
	// Due to all the input buttons, the page sets the default focus field
	// wrong, so we have to provide our own ValidationDelegate subclasss that
	// overrides the getFocusField() method.
	// Subclasses of this base page must initialize it as a bean eg.
	//   @Bean (initializer = "defaultFocusField=name")
	//   public abstract WebFlowValidationDelegate getValidationDelegate();
	public abstract WebFlowValidationDelegate getValidationDelegate();

	@SuppressWarnings("serial")
	static public class WebFlowValidationDelegate extends ValidationDelegate {
		private String _defaultFocusField = null;

		public void setDefaultFocusField(String value) {
			_defaultFocusField = value;
		}

		@Override
		public String getFocusField() {
			if (getHasErrors()) {
				return super.getFocusField();
			}
			else {
				if (_defaultFocusField == null) {
					throw new IllegalStateException("Page must initialize defaultFocusField.");
				}
				return _defaultFocusField;
			}
		}
	}
}
