package jumpstart.max.web.pages.examples.webflow;


import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.engine.ILink;

public abstract class WebFlow2FinishPage extends WebFlow2BasePage {
	static public final String PAGE_NAME = "pages/examples/webflow/WebFlow2FinishPage";

	@Override
	// Beans get created and destroyed on the fly per request cycle
	// Our own validation delegate class allows us to set the focus field!
	@Bean(initializer = "defaultFocusField=next")
	public abstract WebFlowValidationDelegate getValidationDelegate();

	public ILink doNext() {
		ILink redirectTo = null;
		try {
			CreditApplication creditApplication = getCreditApplication();

			// If not a joint applicant, delete the applicant 2 details because
			// it's possible they were entered before jointApplication was
			// turned off

			if (!creditApplication.isJointApplicants()) {
				creditApplication.setApplicant2Name(null);
			}
			creditApplication.validate();

			// In the real world, we'd typically submit the application to the
			// business layer now, as in this commented out section...

			// ICreditManagerSvcLocal manager =
			// getBusinessServicesLocator().getCreditManagerSvcLocal();
			// manager.changeCreditApplication(app);

			// Simulate a waiting period
			sleep(5000);

			redirectTo = getNextLink();
		}
		catch (Exception e) {
			recordError(e.getMessage());
		}
		return redirectTo;
	}

	private void sleep(long millis) {
		try {
			Thread.sleep(millis);
		}
		catch (InterruptedException e) {
			// Ignore
		}
	}
}