package jumpstart.max.web.pages.examples.webflow;


import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.engine.ILink;

public abstract class WebFlow2StartPage extends WebFlow2BasePage {
	static public final String PAGE_NAME = "pages/examples/webflow/WebFlow2StartPage";

	@Override
	// Beans get created and destroyed on the fly per request cycle
	// Our own validation delegate class allows us to set the focus field!
	@Bean(initializer = "defaultFocusField=amount")
	public abstract WebFlowValidationDelegate getValidationDelegate();

	public void activate() {
		CreditApplication creditApplication = new CreditApplication();
		setCreditApplication(creditApplication);
		getRequestCycle().activate(this);
	}

	public ILink doNext() {
		ILink redirectTo = null;
		try {
			getCreditApplication().validateBasics();
			redirectTo = getNextLink();
		}
		catch (Exception e) {
			recordError(e.getMessage(), "amount");
		}
		return redirectTo;
	}

}