// WebFlowBasePage.java
// The superclass of all pages in this example web flow.  
// Its principal roles are to hold the state object, CreditApplication, and to make the navigation decisions.

package jumpstart.max.web.pages.examples.webflow;

import jumpstart.max.web.commons.annotations.InjectExternalLink;
import jumpstart.max.web.pages.login.LoginPage;

import org.apache.tapestry.IAsset;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Asset;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.BasePage;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class WebFlowBasePage extends BasePage implements IExternalPage {

	@Persist("client:form")
	public abstract CreditApplication getCreditApplication();
	public abstract void setCreditApplication(CreditApplication value);

	@InjectExternalLink(WebFlowStartPage.PAGE_NAME)
	public abstract ILink getWebFlowStartPageLink(CreditApplication app);

	@InjectExternalLink(WebFlowApplicant1Page.PAGE_NAME)
	public abstract ILink getWebFlowApplicant1PageLink(CreditApplication app);

	@InjectExternalLink(WebFlowApplicant2Page.PAGE_NAME)
	public abstract ILink getWebFlowApplicant2PageLink(CreditApplication app);

	@InjectExternalLink(WebFlowFinishPage.PAGE_NAME)
	public abstract ILink getWebFlowFinishPageLink(CreditApplication app);

	@InjectExternalLink(WebFlowResultPage.PAGE_NAME)
	public abstract ILink getWebFlowResultPageLink(CreditApplication app);

	@Bean
	// Beans get created and destroyed on the fly per request cycle
	public abstract ValidationDelegate getValidationDelegate();

	@Asset("context:/css/examples_webflow.css")
	public abstract IAsset getStylesheet();

	public int getStepNum() {
		int stepNum = 0;
		if (this instanceof WebFlowStartPage) {
			stepNum = 1;
		}
		else if (this instanceof WebFlowApplicant1Page) {
			stepNum = 2;
		}
		else if (this instanceof WebFlowApplicant2Page) {
			stepNum = 3;
		}
		else if (this instanceof WebFlowFinishPage) {
			stepNum = 4;
		}
		else {
			throw new IllegalStateException("Page type not expected.  Found " + this.getClass().getName());
		}
		return stepNum;
	}

	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		CreditApplication creditApplication = (CreditApplication) parameters[0];
		setCreditApplication(creditApplication);
		getRequestCycle().activate(this);
	}

	protected ILink getNextLink() {
		ILink nextPageLink = null;
		CreditApplication creditApplication = getCreditApplication();

		if (this instanceof WebFlowStartPage) {
			nextPageLink = getWebFlowApplicant1PageLink(creditApplication);
		}
		else if (this instanceof WebFlowApplicant1Page) {
			if (creditApplication.isJointApplicants()) {
				nextPageLink = getWebFlowApplicant2PageLink(creditApplication);
			}
			else {
				nextPageLink = getWebFlowFinishPageLink(creditApplication);
			}
		}
		else if (this instanceof WebFlowApplicant2Page) {
			nextPageLink = getWebFlowFinishPageLink(creditApplication);
		}
		else if (this instanceof WebFlowFinishPage) {
			nextPageLink = getWebFlowResultPageLink(creditApplication);
		}
		else {
			throw new IllegalStateException("Page type not expected.  Found " + this.getClass().getName());
		}

		return nextPageLink;
	}

	public ILink doPrev() {
		ILink prevPageLink = null;
		CreditApplication creditApplication = getCreditApplication();

		if (this instanceof WebFlowApplicant1Page) {
			prevPageLink = getWebFlowStartPageLink(creditApplication);
		}
		else if (this instanceof WebFlowApplicant2Page) {
			prevPageLink = getWebFlowApplicant1PageLink(creditApplication);
		}
		else if (this instanceof WebFlowFinishPage) {
			if (creditApplication.isJointApplicants()) {
				prevPageLink = getWebFlowApplicant2PageLink(creditApplication);
			}
			else {
				prevPageLink = getWebFlowApplicant1PageLink(creditApplication);
			}
		}
		else {
			throw new IllegalStateException("Page type not expected.  Found " + this.getClass().getName());
		}

		return prevPageLink;
	}

	public void doToStartAgain() {
		WebFlowStartPage nextPage = (WebFlowStartPage) getRequestCycle().getPage(WebFlowStartPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLogin() {
		LoginPage nextPage = (LoginPage) getRequestCycle().getPage(LoginPage.PAGE_NAME);
		nextPage.activate();
	}

	protected void recordError(String message) {
		ValidationDelegate delegate = getValidationDelegate();
		delegate.setFormComponent(null);
		delegate.record(message, null);
	}

	protected void recordError(String message, String fieldName) {
		ValidationDelegate delegate = getValidationDelegate();
		delegate.setFormComponent((IFormComponent) getComponent(fieldName));
		delegate.record(message, null);
	}

	protected boolean hasErrors() {
		boolean hasErrors = getValidationDelegate().getHasErrors();
		return hasErrors;
	}
}
