package jumpstart.max.web.pages.examples.webflow;


import org.apache.tapestry.engine.ILink;

public abstract class WebFlowFinishPage extends WebFlowBasePage {
	static public final String PAGE_NAME = "pages/examples/webflow/WebFlowFinishPage";

	public ILink doNext() {
		ILink redirectTo = null;
		try {
			CreditApplication creditApplication = getCreditApplication();

			// If not a joint applicant, delete the applicant 2 details because
			// it's possible they were entered before jointApplication was
			// turned off

			if (!creditApplication.isJointApplicants()) {
				creditApplication.setApplicant2Name(null);
			}
			creditApplication.validate();
			
			// In the real world, we'd typically submit the application to the
			// business layer now, as in this commented out section...

			// ICreditManagerSvcLocal manager = getBusinessServicesLocator().getCreditManagerSvcLocal();
			// manager.changeCreditApplication(app);
			
			// Simulate a waiting period
			sleep(5000);

			redirectTo = getNextLink();
		}
		catch (Exception e) {
			recordError(e.getMessage());
		}
		return redirectTo;
	}
	
	private void sleep(long millis) {
		try {
			Thread.sleep(millis);
		}
		catch (InterruptedException e) {
			// Ignore
		}
	}
}