package jumpstart.max.web.pages.exception;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.html.BasePage;

/**
 * A user-friendly page to display when a system exception occurs. It is suitable for production environments because it
 * hides all technical information. In development environments, it's preferable to use Tapestry's default Exception
 * page. For more information see web/src/main/examples/conf/README.
 */

public abstract class UserFriendlySystemExceptionPage extends BasePage implements PageDetachListener {

	static private final Log LOG = LogFactory.getLog(UserFriendlySystemExceptionPage.class);

	public void setException(Throwable value) {
		LOG.error("UserFriendlySystemExceptionPage shown");
		logErrorAndCauses(value);
	}

	public boolean isDynamic() {
		return getRequestCycle().getResponseBuilder().isDynamic();
	}

	private void logErrorAndCauses(Throwable t) {
		Throwable cause = t.getCause();

		if (cause == null || t.equals(cause)) {
			LOG.error("    caused by: " + ExceptionUtils.getFullStackTrace(t));
		}
		else {
			LOG.error("    caused by: " + t);
			logErrorAndCauses(cause);
		}
	}
}
