package jumpstart.max.web.pages.login;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.web.commons.annotations.InjectPageLink;
import jumpstart.max.web.pages.base.SimpleBasePage;
import jumpstart.max.web.pages.examples.ajax.BasicAJAXPage;
import jumpstart.max.web.pages.examples.ajax.EventListenerPage;
import jumpstart.max.web.pages.examples.ajax.MoreAJAXPage;
import jumpstart.max.web.pages.examples.beanform.BeanFormPage;
import jumpstart.max.web.pages.examples.dupes.DoItOnceAndRedirectPage;
import jumpstart.max.web.pages.examples.dupes.DoItOnceComponentsPage;
import jumpstart.max.web.pages.examples.dupes.DuplicateSubmissionPage;
import jumpstart.max.web.pages.examples.dupes.TheSynchronizerTokenPage;
import jumpstart.max.web.pages.examples.infrastructure.CustomExceptionPage;
import jumpstart.max.web.pages.examples.infrastructure.EngineServicesAndRestartPage;
import jumpstart.max.web.pages.examples.infrastructure.FriendlyURLsPage;
import jumpstart.max.web.pages.examples.jodatime.JodaTimePage;
import jumpstart.max.web.pages.examples.localization.LocalizationByLocalizedTemplatePage;
import jumpstart.max.web.pages.examples.localization.LocalizationByMessageCatalogPage;
import jumpstart.max.web.pages.examples.returns.RestoreFromSessionPage;
import jumpstart.max.web.pages.examples.returns.ReturnAnywhereUCPPage;
import jumpstart.max.web.pages.examples.returns.ReturnAnywhereUHFPage;
import jumpstart.max.web.pages.examples.returns.SimpleRestoreOnReturnPage;
import jumpstart.max.web.pages.examples.simple.SimpleEditPage;
import jumpstart.max.web.pages.examples.simple.SimpleInputPage;
import jumpstart.max.web.pages.examples.simple.SimpleOutputUsingActivatePage;
import jumpstart.max.web.pages.examples.simple.SimpleValidationPage;
import jumpstart.max.web.pages.examples.styling.CSSPage;
import jumpstart.max.web.pages.examples.styling.SwitchableStylePage;
import jumpstart.max.web.pages.examples.tables.AlternatingTableComponentPage;
import jumpstart.max.web.pages.examples.tables.AlternatingTablePage;
import jumpstart.max.web.pages.examples.tables.PreviewableTableComponentPage;
import jumpstart.max.web.pages.examples.tables.PreviewableTablePage;
import jumpstart.max.web.pages.examples.tables.TableComponentPage;
import jumpstart.max.web.pages.examples.tables.TableComponentWithLinksPage;
import jumpstart.max.web.pages.examples.tables.TablePage;
import jumpstart.max.web.pages.examples.tables.TableViewComponentPage;
import jumpstart.max.web.pages.examples.tables.TableWithLinksPage;
import jumpstart.max.web.pages.examples.validators.ClientValidatorsPage;
import jumpstart.max.web.pages.examples.validators.ClientValidatorsWithFieldLabelsPage;
import jumpstart.max.web.pages.examples.validators.MixedValidationPage;
import jumpstart.max.web.pages.examples.validators.MixedValidationWithFieldLabelsPage;
import jumpstart.max.web.pages.examples.validators.ValidatorsPage;
import jumpstart.max.web.pages.examples.validators.ValidatorsWithFieldLabelsPage;
import jumpstart.max.web.pages.examples.webflow.WebFlow2StartPage;
import jumpstart.max.web.pages.examples.webflow.WebFlowStartPage;
import jumpstart.max.web.state.Visit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.ILink;

/**
 * Allows the user to login, by providing userName and password. After succesfully logging in.
 * 
 * @author Geoff Callender
 */

public abstract class LoginPage extends SimpleBasePage {
	static public final Log LOG = LogFactory.getLog(LoginPage.class);

	static public final String PAGE_NAME = "pages/login/LoginPage";

	@InjectPageLink(WelcomePage.PAGE_NAME)
	public abstract ILink getWelcomePageLink();

	// @Asset("context:/css/login.css")
	// In Tapestry 4.1, have to use <asset> in LoginPage.page instead of @Asset
	// here. Otherwise a problem occurs when when other pages activate this
	// page: "Component pages/login/LoginPage does not contain an asset named
	// 'stylesheet'."
	// Wasn't a problem in Tapestry 4.0. Might only occur when there's a .page.
	// public abstract IAsset getStylesheet();

	public abstract void setUserName(String value);

	public abstract String getLoginId();

	public abstract void setPassword(String value);
	public abstract String getPassword();

	public void activate() {
		// No preparation required before activation.
		getRequestCycle().activate(this);
	}

	public void doToSimpleOutputUsingActivate() {
		SimpleOutputUsingActivatePage nextPage = (SimpleOutputUsingActivatePage) getRequestCycle().getPage(
				SimpleOutputUsingActivatePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToSimpleInput() {
		SimpleInputPage nextPage = (SimpleInputPage) getRequestCycle().getPage(SimpleInputPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToSimpleValidation() {
		SimpleValidationPage nextPage = (SimpleValidationPage) getRequestCycle()
				.getPage(SimpleValidationPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToSimpleEdit() {
		SimpleEditPage nextPage = (SimpleEditPage) getRequestCycle().getPage(SimpleEditPage.PAGE_NAME);
		Long personId = new Long(1);
		nextPage.activate(personId);
	}

	public void doToValidators() {
		ValidatorsPage nextPage = (ValidatorsPage) getRequestCycle().getPage(ValidatorsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToValidatorsWithFieldLabels() {
		ValidatorsWithFieldLabelsPage nextPage = (ValidatorsWithFieldLabelsPage) getRequestCycle().getPage(
				ValidatorsWithFieldLabelsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToClientValidators() {
		ClientValidatorsPage nextPage = (ClientValidatorsPage) getRequestCycle()
				.getPage(ClientValidatorsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToClientValidatorsWithFieldLabels() {
		ClientValidatorsWithFieldLabelsPage nextPage = (ClientValidatorsWithFieldLabelsPage) getRequestCycle().getPage(
				ClientValidatorsWithFieldLabelsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToMixedValidation() {
		MixedValidationPage nextPage = (MixedValidationPage) getRequestCycle().getPage(MixedValidationPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToMixedValidationWithFieldLabels() {
		MixedValidationWithFieldLabelsPage nextPage = (MixedValidationWithFieldLabelsPage) getRequestCycle().getPage(
				MixedValidationWithFieldLabelsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToBeanForm() {
		BeanFormPage nextPage = (BeanFormPage) getRequestCycle().getPage(BeanFormPage.PAGE_NAME);
		Long personId = new Long(1);
		nextPage.activate(personId);
	}

	public void doToCSS() {
		CSSPage nextPage = (CSSPage) getRequestCycle().getPage(CSSPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToSwitchableStyle() {
		SwitchableStylePage nextPage = (SwitchableStylePage) getRequestCycle().getPage(SwitchableStylePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToBasicAJAX() {
		BasicAJAXPage nextPage = (BasicAJAXPage) getRequestCycle().getPage(BasicAJAXPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToMoreAJAX() {
		MoreAJAXPage nextPage = (MoreAJAXPage) getRequestCycle().getPage(MoreAJAXPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToEventListener() {
		EventListenerPage nextPage = (EventListenerPage) getRequestCycle().getPage(EventListenerPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToTable() {
		TablePage nextPage = (TablePage) getRequestCycle().getPage(TablePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToTableComponent() {
		TableComponentPage nextPage = (TableComponentPage) getRequestCycle().getPage(TableComponentPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToTableWithLinks() {
		TableWithLinksPage nextPage = (TableWithLinksPage) getRequestCycle().getPage(TableWithLinksPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToTableComponentWithLinks() {
		TableComponentWithLinksPage nextPage = (TableComponentWithLinksPage) getRequestCycle().getPage(
				TableComponentWithLinksPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToPreviewableTable() {
		PreviewableTablePage nextPage = (PreviewableTablePage) getRequestCycle()
				.getPage(PreviewableTablePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToPreviewableTableComponent() {
		PreviewableTableComponentPage nextPage = (PreviewableTableComponentPage) getRequestCycle().getPage(
				PreviewableTableComponentPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToAlternatingTable() {
		AlternatingTablePage nextPage = (AlternatingTablePage) getRequestCycle()
				.getPage(AlternatingTablePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToAlternatingTableComponent() {
		AlternatingTableComponentPage nextPage = (AlternatingTableComponentPage) getRequestCycle().getPage(
				AlternatingTableComponentPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToTableViewComponent() {
		TableViewComponentPage nextPage = (TableViewComponentPage) getRequestCycle().getPage(
				TableViewComponentPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLocalizationByMessageCatalog() {
		LocalizationByMessageCatalogPage nextPage = (LocalizationByMessageCatalogPage) getRequestCycle().getPage(
				LocalizationByMessageCatalogPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToLocalizationByLocalizedTemplate() {
		LocalizationByLocalizedTemplatePage nextPage = (LocalizationByLocalizedTemplatePage) getRequestCycle().getPage(
				LocalizationByLocalizedTemplatePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToEngineServicesAndRestart() {
		EngineServicesAndRestartPage nextPage = (EngineServicesAndRestartPage) getRequestCycle().getPage(
				EngineServicesAndRestartPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToFriendlyURLs() {
		FriendlyURLsPage nextPage = (FriendlyURLsPage) getRequestCycle().getPage(FriendlyURLsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToSimpleRestoreOnReturn() {
		SimpleRestoreOnReturnPage nextPage = (SimpleRestoreOnReturnPage) getRequestCycle().getPage(
				SimpleRestoreOnReturnPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToRestoreFromSession() {
		RestoreFromSessionPage nextPage = (RestoreFromSessionPage) getRequestCycle().getPage(
				RestoreFromSessionPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToReturnAnywhereUHF() {
		ReturnAnywhereUHFPage nextPage = (ReturnAnywhereUHFPage) getRequestCycle().getPage(
				ReturnAnywhereUHFPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToReturnAnywhereUCP() {
		ReturnAnywhereUCPPage nextPage = (ReturnAnywhereUCPPage) getRequestCycle().getPage(
				ReturnAnywhereUCPPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToDuplicateSubmission() {
		DuplicateSubmissionPage nextPage = (DuplicateSubmissionPage) getRequestCycle().getPage(
				DuplicateSubmissionPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToTheSynchronizerToken() {
		TheSynchronizerTokenPage nextPage = (TheSynchronizerTokenPage) getRequestCycle().getPage(
				TheSynchronizerTokenPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToDoItOnceComponents() {
		DoItOnceComponentsPage nextPage = (DoItOnceComponentsPage) getRequestCycle().getPage(
				DoItOnceComponentsPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToDoItOnceAndRedirect() {
		DoItOnceAndRedirectPage nextPage = (DoItOnceAndRedirectPage) getRequestCycle().getPage(
				DoItOnceAndRedirectPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToWebFlow() {
		WebFlowStartPage nextPage = (WebFlowStartPage) getRequestCycle().getPage(WebFlowStartPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToWebFlow2() {
		WebFlow2StartPage nextPage = (WebFlow2StartPage) getRequestCycle().getPage(WebFlow2StartPage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToJodaTime() {
		JodaTimePage nextPage = (JodaTimePage) getRequestCycle().getPage(JodaTimePage.PAGE_NAME);
		nextPage.activate();
	}

	public void doToCustomException() {
		CustomExceptionPage nextPage = (CustomExceptionPage) getRequestCycle().getPage(CustomExceptionPage.PAGE_NAME);
		nextPage.activate();
	}

	public ILink doLogin() {
		ILink redirectTo = null;

		try {
			validate();

			if (hasErrors()) {
				return null;
			}

			// Authenticate the user, password

			ISecurityFinderSvcLocal finder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
			User user = finder.authenticateUser(getLoginId(), getPassword());

			// Store the user and roles in the Visit

			Visit visit = getMyVisit();
			visit.noteLogIn(user);
			LOG.info(user.getLoginId() + " has logged in.");

			// Redirect to next page.
			// SECURITY NOTE - do not use simple page activation Instead, we
			// return an ILink because that instructs Tapestry to do
			// a redirect-after-post.
			// Redirect-after-post protects against a security vulnerability in
			// which a user may log in without a password simply by using a
			// browser that has been logged out, then using the Back button to
			// go back to the first screen after the login screen and
			// pressing refresh.
			// Without redirect-after-post this would re-post the login info
			// and they'd be logged in!

			redirectTo = getWelcomePageLink();
		}
		catch (BusinessException e) {
			recordError(e.getMessage());
		}

		return redirectTo;
	}

	private void validate() {
		// None to do - validation has been specified in the HTML template
	}

	public void validate(IRequestCycle cycle) {
		super.validate(cycle);
	}

}
