package jumpstart.max.web.pages.login;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.pages.base.ProtectedBasePage;
import jumpstart.max.web.pages.security.FormatPatterns;
import jumpstart.max.web.state.Visit;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class OptionsEditPage extends ProtectedBasePage {
	// static private final Log LOG = LogFactory.getLog(OptionsEditPage.class);
	static public final String PAGE_NAME = "pages/login/OptionsEditPage";

	@Persist("session")
	// Probably best not to use client persistence, even though it encodes the
	// field, because User includes password
	public abstract User getUser();
	public abstract void setUser(User value);

	public abstract int getStyleId();
	public abstract void setStyleId(int value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getDateInputPatternsModel();
	public abstract void setDateInputPatternsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getDateViewPatternsModel();
	public abstract void setDateViewPatternsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getDateListPatternsModel();
	public abstract void setDateListPatternsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getTime4ViewPatternsModel();
	public abstract void setTime4ViewPatternsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getTime4ListPatternsModel();
	public abstract void setTime4ListPatternsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getTime6ViewPatternsModel();
	public abstract void setTime6ViewPatternsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getTime6ListPatternsModel();
	public abstract void setTime6ListPatternsModel(IPropertySelectionModel value);

	public abstract boolean getShowInspector();
	public abstract void setShowInspector(boolean value);

	public void activate() {
		try {
			Visit visit = getMyVisit();
			setStyleId(visit.getStyleId());
			setShowInspector(visit.isInspectorEnabled());

			// Get the User

			ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
			User user = securityFinder.findUserShallowish(getMyVisit().getMyUserId());
			setUser(user);

			// Put date and time pattern lists on the page

			if (getDateInputPatternsModel() == null) {
				setDateInputPatternsModel(FormatPatterns.DATE_PATTERNS_MODEL);

				setDateViewPatternsModel(FormatPatterns.DATE_PATTERNS_MODEL);
				setTime4ViewPatternsModel(FormatPatterns.TIME4_PATTERNS_MODEL);
				setTime6ViewPatternsModel(FormatPatterns.TIME6_PATTERNS_MODEL);

				setDateListPatternsModel(FormatPatterns.DATE_PATTERNS_MODEL);
				setTime4ListPatternsModel(FormatPatterns.TIME4_PATTERNS_MODEL);
				setTime6ListPatternsModel(FormatPatterns.TIME6_PATTERNS_MODEL);
			}

			getRequestCycle().activate(this);
		}
		catch (BusinessException e) {
			// TODO - don't catch it - throw it. Modify Border to redirect to an error page?
		}
	}

	public void doApply() {
		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Change the User

					User user = getUser();

					manager.changeUser(user);
					getMyVisit().noteChanges(user);

					// Get the User

					ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
					user = securityFinder.findUserShallowish(getMyVisit().getMyUserId());
					setUser(user);

					setInfoMessage(getMessages().getMessage("Options_applied_ok"));
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

}
