package jumpstart.max.web.pages.reference;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class CodeAddPage extends ReturnableProtectedBasePage {
	// static private final Log LOG = LogFactory.getLog(CodeAddPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeAddPage";

	@Persist("client:form")
	public abstract Code getCode();
	public abstract void setCode(Code value);

	@Persist("client:form")
	public abstract CodeGroup getCodeGroup();
	public abstract void setCodeGroup(CodeGroup value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	public void activate(String codeGroupId) throws BusinessException {

		// Use the parent's details

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeGroup codeGroup = referenceFinder1.findCodeGroupShallowish(codeGroupId);

		activate(codeGroup);
	}

	public void activate(CodeGroup codeGroup) throws BusinessException {
		setCode(new Code());

		// Parent - save it and if it's null then put a selection list of
		// codeGroups onto the page

		setCodeGroup(codeGroup);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_CODE_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m1);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					IReferenceManagerSvcLocal manager = getBusinessServicesLocator().getReferenceManagerSvcLocal();

					// Add the Code

					Code code = getCode();
					String codeGroupId = getCodeGroup().getId();
					manager.addCode(code, codeGroupId);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForAdd(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
