package jumpstart.max.web.pages.reference;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class CodeEditPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(OptionsEditPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeEditPage";

	@Persist("client:form")
	public abstract String getCodeId();
	public abstract void setCodeId(String value);

	@Persist("client:form")
	public abstract Code getCode();
	public abstract void setCode(Code value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getCodeGroupsModel();
	public abstract void setCodeGroupsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((String) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(String id) throws BusinessException {
		setCodeId(id);

		// Get the Code

		IReferenceFinderSvcLocal referenceFinder = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		Code code = referenceFinder.findCodeShallowish(id);
		setCode(code);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_CODE_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m1);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					IReferenceManagerSvcLocal manager = getBusinessServicesLocator().getReferenceManagerSvcLocal();

					// Change the Code

					Code code = getCode();
					manager.changeCode(code);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
