package jumpstart.max.web.pages.reference;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class CodeGroupEditPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG =
	// LogFactory.getLog(CodeGroupEditPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeGroupEditPage";

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract String getCodeGroupId();
	public abstract void setCodeGroupId(String value);

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract CodeGroup getCodeGroup();
	public abstract void setCodeGroup(CodeGroup value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Don't use client:form because DirectLinks won't return it
	// Don't use client because the list will be stored in every link on page
	public abstract List<Code> getCodes();
	public abstract void setCodes(List<Code> value);
	public abstract Code getCode();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((String) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(String id) throws BusinessException {
		setCodeGroupId(id);

		// Get the CodeGroup

		IReferenceFinderSvcLocal referenceFinder = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeGroup codeGroup = referenceFinder.findCodeGroupShallowish(id);
		setCodeGroup(codeGroup);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_CODEGROUP_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m1);

		// Put a list of codes onto the page

		listCodes();

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					IReferenceManagerSvcLocal manager = getBusinessServicesLocator().getReferenceManagerSvcLocal();

					// Change the CodeGroup

					CodeGroup codeGroup = getCodeGroup();
					manager.changeCodeGroup(codeGroup);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

	private void listCodes() {

		// Put a list of Codes on the page

		IReferenceFinderSvcLocal referenceFinder = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		List<Code> l = referenceFinder.findCodesShallowishByCodeGroup(getCodeGroup().getId());
		setCodes(l);
	}

	public void doAddCode() {

		try {
			CodeGroup codeGroup = getCodeGroup();
			CodeAddPage nextPage = (CodeAddPage) getRequestCycle().getPage(CodeAddPage.PAGE_NAME);
			nextPage.activate(codeGroup);

			pushExternalCallback(this, new Object[] { getCodeGroupId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doViewCode(String id) {

		try {
			CodeViewPage nextPage = (CodeViewPage) getRequestCycle().getPage(CodeViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getCodeGroupId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doEditCode(String id) {

		try {
			CodeEditPage nextPage = (CodeEditPage) getRequestCycle().getPage(CodeEditPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getCodeGroupId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doRemoveCode(String id) {

		if (!hasErrors()) {

			// Find the Code in the list by id

			Code code = null;
			for (Code code1 : getCodes()) {
				if (code1.getId().equals(id)) {
					code = code1;
					break;
				}
			}

			// If not there it will be because Reload chosen after removing
			// it, so just return
			if (code == null) {
				return;
			}

			try {
				// Remove the entry

				IReferenceManagerSvcLocal manager = getBusinessServicesLocator().getReferenceManagerSvcLocal();
				manager.removeCode(code);

				// Update the codes list on screen

				List<Code> codes = getCodes();
				codes.remove(code);
				setCodes(codes);
			}
			catch (Exception e) {
				handleBusinessServicesExceptionForRemove(e);
			}
		}

	}

}
