package jumpstart.max.web.pages.reference;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeGroupSearchFields;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.form.IPropertySelectionModel;

/**
 * Page class for the application's List${entityBean.Name} page.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.10 $, $Date: 2006/02/15 10:43:06 $
 */
public abstract class CodeGroupSearchPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG =
	// LogFactory.getLog(CodeGroupSearchPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeGroupSearchPage";

	@Persist("client:form")
	public abstract CodeGroupSearchFields getSearch();
	public abstract void setSearch(CodeGroupSearchFields value);

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract CodeGroupSearchFields getLastSearch();
	public abstract void setLastSearch(CodeGroupSearchFields value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Don't use client:form because DirectLinks won't return it
	// Don't use client because the list will be stored in every link on page
	public abstract List<CodeGroup> getCodeGroups();
	public abstract void setCodeGroups(List<CodeGroup> value);

	public abstract CodeGroup getCodeGroup();
	public abstract void setCodeGroup(CodeGroup value);

	@Bean
	public abstract EvenOdd getEvenOdd();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		this.activate((CodeGroupSearchFields) parameters[0]);
	}

	public void activate() {
		doResetSearch();

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	private void activate(CodeGroupSearchFields searchFields) {

		if (searchFields == null) {
			// Assume we're being called back so don't call doResetSearch()
			// because it would
			// unnecessarily refresh the selection lists
			setLastSearch(null);
			setSearch(new CodeGroupSearchFields());
		}
		else {
			doSearch(searchFields);
			setSearch(searchFields);
			setLastSearch(searchFields);
		}

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	public void doResetSearch() {
		setSearch(new CodeGroupSearchFields());
		setLastSearch(null);
		setCodeGroups(null);
		refreshSelectionLists();
	}

	public void refreshSelectionLists() {

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_CODEGROUP_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", "getId",
				true, null);
		setStatusesModel(m1);
	}

	public void doSearch(CodeGroupSearchFields searchFields) {

		if (!hasErrors()) {
			IReferenceFinderSvcLocal finder = getBusinessServicesLocator().getReferenceFinderSvcLocal();

			SearchOptions searchOptions = new SearchOptions();
			List<CodeGroup> l = finder.findCodeGroupsShallowish(searchFields, searchOptions);
			setCodeGroups(l);

			setLastSearch(searchFields);
		}
	}

	public void doNew() {

		try {
			CodeGroupCreatePage nextPage = (CodeGroupCreatePage) getRequestCycle().getPage(
					CodeGroupCreatePage.PAGE_NAME);
			nextPage.activate();

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doView(String id) {

		try {
			CodeGroupViewPage nextPage = (CodeGroupViewPage) getRequestCycle().getPage(CodeGroupViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doEdit(String id) {

		try {
			CodeGroupEditPage nextPage = (CodeGroupEditPage) getRequestCycle().getPage(CodeGroupEditPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doDelete(String id) {

		if (!hasErrors()) {

			// Find the CodeGroup in the list by id

			CodeGroup codeGroup = null;
			for (CodeGroup codeGroup1 : getCodeGroups()) {
				if (codeGroup1.getId().equals(id)) {
					codeGroup = codeGroup1;
					break;
				}
			}

			// If not there it will be because Reload chosen after removing
			// it, so just return
			if (codeGroup == null) {
				return;
			}

			try {
				// Delete the CodeGroup

				IReferenceManagerSvcLocal manager = getBusinessServicesLocator().getReferenceManagerSvcLocal();
				manager.deleteCodeGroup(codeGroup);

				// Update the codeGroups list on screen

				List<CodeGroup> codeGroups = getCodeGroups();
				codeGroups.remove(codeGroup);
				setCodeGroups(codeGroups);
			}
			catch (Exception e) {
				handleBusinessServicesExceptionForDelete(e);
			}
		}

	}

}
