package jumpstart.max.web.pages.reference;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;

public abstract class CodeGroupViewPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG =
	// LogFactory.getLog(CodeGroupViewPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeGroupViewPage";

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract String getCodeGroupId();
	public abstract void setCodeGroupId(String value);

	@Persist("client:form")
	public abstract CodeGroup getCodeGroup();
	public abstract void setCodeGroup(CodeGroup value);

	@Persist("client:form")
	public abstract List<Code> getCodes();
	public abstract void setCodes(List<Code> value);
	public abstract Code getCode();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((String) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(String id) throws BusinessException {
		setCodeGroupId(id);

		// Get the CodeGroup

		IReferenceFinderSvcLocal referenceFinder = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeGroup codeGroup = referenceFinder.findCodeGroupShallowish(id);
		setCodeGroup(codeGroup);

		// Put a list of codes onto the page

		listCodes();

		getRequestCycle().activate(this);
	}

	public void doCancel() {
		popAndActivateCallback();
	}

	private void listCodes() {

		// Put a list of codes on the page

		IReferenceFinderSvcLocal referenceFinder = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		List<Code> l = referenceFinder.findCodesShallowishByCodeGroup(getCodeGroup().getId());
		setCodes(l);
	}

	public void doViewCode(String id) {

		try {
			CodeViewPage nextPage = (CodeViewPage) getRequestCycle().getPage(CodeViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getCodeGroupId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

}
