package jumpstart.max.web.pages.reference;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.reference.iface.IReferenceManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.form.IPropertySelectionModel;

/**
 * Page class for the application's List${entityBean.Name} page.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.10 $, $Date: 2006/02/15 10:43:06 $
 */
public abstract class CodeSearchPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(CodeSearchPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeSearchPage";

	@Persist("client:form")
	public abstract CodeSearchFields getSearch();
	public abstract void setSearch(CodeSearchFields value);

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract CodeSearchFields getLastSearch();
	public abstract void setLastSearch(CodeSearchFields value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getCodeGroupsModel();
	public abstract void setCodeGroupsModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Don't use client:form because DirectLinks won't return it
	// Don't use client because the list will be stored in every link on page
	public abstract List<Code> getCodes();
	public abstract void setCodes(List<Code> value);

	public abstract Code getCode();
	public abstract void setCode(Code value);

	@Bean
	public abstract EvenOdd getEvenOdd();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		this.activate((CodeSearchFields) parameters[0]);
	}

	public void activate() {
		doResetSearch();

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	private void activate(CodeSearchFields searchFields) {

		if (searchFields == null) {
			// Assume we're being called back so don't call doResetSearch()
			// because it would
			// unnecessarily refresh the selection lists
			setLastSearch(null);
			setSearch(new CodeSearchFields());
		}
		else {
			doSearch(searchFields);
			setSearch(searchFields);
			setLastSearch(searchFields);
		}

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	public void doResetSearch() {
		setSearch(new CodeSearchFields());
		setLastSearch(null);
		setCodes(null);
		refreshSelectionLists();
	}

	public void refreshSelectionLists() {

		// Put a selection list of codeGroups onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		List<CodeGroup> codeGroups = referenceFinder1.findCodeGroupsShallowish();
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(codeGroups, CodeGroup.class, "getDescription",
				"getId", true, null);
		setCodeGroupsModel(m1);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder2 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search2 = new CodeSearchFields();
		search2.setCodeGroupId(CodeGroup.ID_CODE_STATUS);
		search2.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder2.findCodesShallowish(search2, new SearchOptions());
		IPropertySelectionModel m2 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", "getId",
				true, null);
		setStatusesModel(m2);
	}

	public void doSearch(CodeSearchFields searchFields) {

		if (!hasErrors()) {
			IReferenceFinderSvcLocal finder = getBusinessServicesLocator().getReferenceFinderSvcLocal();

			SearchOptions searchOptions = new SearchOptions();
			List<Code> l = finder.findCodesShallowish(searchFields, searchOptions);
			setCodes(l);

			setLastSearch(searchFields);
		}
	}

	public void doView(String id) {

		try {
			CodeViewPage nextPage = (CodeViewPage) getRequestCycle().getPage(CodeViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doEdit(String id) {

		try {
			CodeEditPage nextPage = (CodeEditPage) getRequestCycle().getPage(CodeEditPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doRemove(String id) {

		if (!hasErrors()) {

			// Find the Code in the list by id

			Code code = null;
			for (Code code1 : getCodes()) {
				if (code1.getId().equals(id)) {
					code = code1;
					break;
				}
			}

			// If not there it will be because Reload chosen after removing
			// it, so just return
			if (code == null) {
				return;
			}

			try {
				// Delete the Code

				IReferenceManagerSvcLocal manager = getBusinessServicesLocator().getReferenceManagerSvcLocal();
				manager.removeCode(code);

				// Update the codes list on screen

				List<Code> codes = getCodes();
				codes.remove(code);
				setCodes(codes);
			}
			catch (Exception e) {
				handleBusinessServicesExceptionForRemove(e);
			}
		}

	}

}
