package jumpstart.max.web.pages.reference;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class CodeViewPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(CodeViewPage.class);
	static public final String PAGE_NAME = "pages/reference/CodeViewPage";

	@Persist("client:form")
	public abstract String getCodeId();
	public abstract void setCodeId(String value);

	@Persist("client:form")
	public abstract Code getCode();
	public abstract void setCode(Code value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getCodeGroupsModel();
	public abstract void setCodeGroupsModel(IPropertySelectionModel value);

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((String) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(String id) throws BusinessException {
		setCodeId(id);

		// Get the Code

		IReferenceFinderSvcLocal referenceFinder = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		Code code = referenceFinder.findCodeShallowish(id);
		setCode(code);

		getRequestCycle().activate(this);
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
