package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class MyProfileEditPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(UserEditPage.class);
	static public final String PAGE_NAME = "pages/security/MyProfileEditPage";

	@Persist("session")
	// Probably best not to use client persistence, even though it encodes the
	// field, because User includes password
	public abstract User getUser();
	public abstract void setUser(User value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getSalutationsModel();
	public abstract void setSalutationsModel(IPropertySelectionModel value);

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate();
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate() throws BusinessException {

		// Get the User

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		User user = securityFinder.findUserShallowish(getMyVisit().getMyUserId());
		setUser(user);

		// Put a selection list of salutations onto the page

		IReferenceFinderSvcLocal referenceFinder2 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search2 = new CodeSearchFields();
		search2.setCodeGroupId(CodeGroup.ID_USER_SALUTATION);
		search2.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> salutations = referenceFinder2.findCodesShallowish(search2, new SearchOptions());
		IPropertySelectionModel m2 = new ObjectPropertySelectionModel(salutations, Code.class, "getDescription", null,
				true, "");
		setSalutationsModel(m2);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Change the User

					User user = getUser();
					manager.changeUser(user);
					getMyVisit().noteChanges(user);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
