package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class RoleEditPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(RoleEditPage.class);
	static public final String PAGE_NAME = "pages/security/RoleEditPage";

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract Long getRoleId();
	public abstract void setRoleId(Long value);

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract Role getRole();
	public abstract void setRole(Role value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Don't use client:form because DirectLinks won't return it
	// Don't use client because the list will be stored in every link on page
	public abstract List<UserRole> getUserRoles();
	public abstract void setUserRoles(List<UserRole> value);
	public abstract UserRole getUserRole();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((Long) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(Long id) throws BusinessException {
		setRoleId(id);

		// Get the Role

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		Role role = securityFinder.findRoleShallowish(id);
		setRole(role);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_ROLE_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m1);

		// Put a list of userRoles onto the page

		listUserRoles();

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Change the Role

					Role role = getRole();
					manager.changeRole(role);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

	private void listUserRoles() {

		// Put a list of UserRoles on the page

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		List<UserRole> l = securityFinder.findUserRolesShallowishByRole(getRole().getId());
		setUserRoles(l);
	}

	public void doAddUserRole() {

		try {
			User user = null;
			Role role = getRole();
			UserRoleAddPage nextPage = (UserRoleAddPage) getRequestCycle().getPage(UserRoleAddPage.PAGE_NAME);
			nextPage.activate(user, role);

			pushExternalCallback(this, new Object[] { getRoleId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doViewUserRole(Long id) {

		try {
			UserRoleViewPage nextPage = (UserRoleViewPage) getRequestCycle().getPage(UserRoleViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getRoleId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doEditUserRole(Long id) {

		try {
			UserRoleEditPage nextPage = (UserRoleEditPage) getRequestCycle().getPage(UserRoleEditPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getRoleId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doRemoveUserRole(Long id) {

		if (!hasErrors()) {

			// Find the UserRole in the list by id

			UserRole userRole = null;
			for (UserRole userRole1 : getUserRoles()) {
				if (userRole1.getId().equals(id)) {
					userRole = userRole1;
					break;
				}
			}

			// If not there it will be because Reload chosen after removing
			// it, so just redisplay
			if (userRole == null) {
				return;
			}

			try {
				// Remove the entry

				ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();
				manager.removeUserRole(userRole);

				// Update the userRoles list on screen

				List<UserRole> userRoles = getUserRoles();
				userRoles.remove(userRole);
				setUserRoles(userRoles);
			}
			catch (Exception e) {
				handleBusinessServicesExceptionForRemove(e);
			}
		}

	}

}
