package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.business.domain.security.iface.RoleSearchFields;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.form.IPropertySelectionModel;

/**
 * Page class for the application's List${entityBean.Name} page.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.10 $, $Date: 2006/02/15 10:43:06 $
 */
public abstract class RoleSearchPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(RoleSearchPage.class);
	static public final String PAGE_NAME = "pages/security/RoleSearchPage";

	@Persist("client:form")
	public abstract RoleSearchFields getSearch();
	public abstract void setSearch(RoleSearchFields value);

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract RoleSearchFields getLastSearch();
	public abstract void setLastSearch(RoleSearchFields value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Don't use client:form because DirectLinks won't return it
	// Don't use client because the list will be stored in every link on page
	public abstract List<Role> getRoles();
	public abstract void setRoles(List<Role> value);

	public abstract Role getRole();
	public abstract void setRole(Role value);

	@Bean
	public abstract EvenOdd getEvenOdd();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		this.activate((RoleSearchFields) parameters[0]);
	}

	public void activate() {
		doResetSearch();

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	private void activate(RoleSearchFields searchFields) {

		if (searchFields == null) {
			// Assume we're being called back so don't call doResetSearch()
			// because it would
			// unnecessarily refresh the selection lists
			setLastSearch(null);
			setSearch(new RoleSearchFields());
		}
		else {
			doSearch(searchFields);
			setSearch(searchFields);
			setLastSearch(searchFields);
		}

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	public void doResetSearch() {
		setSearch(new RoleSearchFields());
		setLastSearch(null);
		setRoles(null);
		refreshSelectionLists();
	}

	public void refreshSelectionLists() {

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_ROLE_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", "getId",
				true, null);
		setStatusesModel(m1);
	}

	public void doSearch(RoleSearchFields searchFields) {

		if (!hasErrors()) {
			ISecurityFinderSvcLocal finder = getBusinessServicesLocator().getSecurityFinderSvcLocal();

			SearchOptions searchOptions = new SearchOptions();
			List<Role> l = finder.findRolesShallowish(searchFields, searchOptions);
			setRoles(l);

			setLastSearch(searchFields);
		}
	}

	public void doNew() {

		try {
			RoleCreatePage nextPage = (RoleCreatePage) getRequestCycle().getPage(RoleCreatePage.PAGE_NAME);
			nextPage.activate();

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doView(Long id) {

		try {
			RoleViewPage nextPage = (RoleViewPage) getRequestCycle().getPage(RoleViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doEdit(Long id) {

		try {
			RoleEditPage nextPage = (RoleEditPage) getRequestCycle().getPage(RoleEditPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doDelete(Long id) {

		if (!hasErrors()) {

			// Find the Role in the list by id

			Role role = null;
			for (Role role1 : getRoles()) {
				if (role1.getId().equals(id)) {
					role = role1;
					break;
				}
			}

			// If not there it will be because Reload chosen after removing
			// it, so just return
			if (role == null) {
				return;
			}

			try {
				// Delete the Role

				ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();
				manager.deleteRole(role);

				// Update the roles list on screen

				List<Role> roles = getRoles();
				roles.remove(role);
				setRoles(roles);
			}
			catch (Exception e) {
				handleBusinessServicesExceptionForDelete(e);
			}
		}

	}

}
