package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;

public abstract class RoleViewPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(RoleViewPage.class);
	static public final String PAGE_NAME = "pages/security/RoleViewPage";

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract Long getRoleId();
	public abstract void setRoleId(Long value);

	@Persist("client:form")
	public abstract Role getRole();
	public abstract void setRole(Role value);

	@Persist("client:form")
	public abstract List<UserRole> getUserRoles();
	public abstract void setUserRoles(List<UserRole> value);
	public abstract UserRole getUserRole();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((Long) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(Long id) throws BusinessException {
		setRoleId(id);

		// Get the Role

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		Role role = securityFinder.findRoleShallowish(id);
		setRole(role);

		// Put a list of userRoles onto the page

		listUserRoles();

		getRequestCycle().activate(this);
	}

	public void doCancel() {
		popAndActivateCallback();
	}

	private void listUserRoles() {

		// Put a list of userRoles on the page

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		List<UserRole> l = securityFinder.findUserRolesShallowishByRole(getRole().getId());
		setUserRoles(l);
	}

	public void doViewUserRole(Long id) {

		try {
			UserRoleViewPage nextPage = (UserRoleViewPage) getRequestCycle().getPage(UserRoleViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getRoleId() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

}
