package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class UserCreatePage extends ReturnableProtectedBasePage {
	// static private final Log LOG = LogFactory.getLog(UserCreatePage.class);
	static public final String PAGE_NAME = "pages/security/UserCreatePage";

	@Persist("client:form")
	public abstract User getUser();
	public abstract void setUser(User value);

	public abstract String getPassword();
	public abstract String getConfirmPassword();

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getSalutationsModel();
	public abstract void setSalutationsModel(IPropertySelectionModel value);

	public void activate() throws BusinessException {

		// Create the User

		User user = new User();

		user.setDateInputPattern("dd/MM/yy");
		user.setDateViewPattern("dd MMM yyyy");
		user.setDateListPattern("dd/MM/yy");

		setUser(user);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_USER_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m1);

		// Put a selection list of salutations onto the page

		IReferenceFinderSvcLocal referenceFinder2 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search2 = new CodeSearchFields();
		search2.setCodeGroupId(CodeGroup.ID_USER_SALUTATION);
		search2.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> salutations = referenceFinder2.findCodesShallowish(search2, new SearchOptions());
		IPropertySelectionModel m2 = new ObjectPropertySelectionModel(salutations, Code.class, "getDescription", null,
				true, "");
		setSalutationsModel(m2);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Create the User

					User user = getUser();
					String password = getPassword();
					manager.createUser(user, password);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForCreate(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {

		if (!getPassword().equals(getConfirmPassword())) {
			recordError(getMessages().getMessage("User_confirmpassword_does_not_match"), "password");
		}
	}

	public void doCancel() {
		setUser(null);
		popAndActivateCallback();
	}

}
