package jumpstart.max.web.pages.security;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;

public abstract class UserPasswordChangePage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG =
	// LogFactory.getLog(UserPasswordChangePage.class);
	static public final String PAGE_NAME = "pages/security/UserPasswordChangePage";

	@Persist("client:form")
	public abstract Long getUserId();
	public abstract void setUserId(Long value);

	@Persist("session")
	// Probably best not to use client persistence, even though it encodes the
	// field, because User includes password
	public abstract User getUser();
	public abstract void setUser(User value);

	public abstract String getNewPassword();
	public abstract String getConfirmNewPassword();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((Long) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(Long id) throws BusinessException {
		setUserId(id);

		// Get the User

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		User user = securityFinder.findUserShallowish(id);
		setUser(user);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Change the User password

					manager.changeUserPassword(getUserId(), getNewPassword());

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {

		if (!getNewPassword().equals(getConfirmNewPassword())) {
			recordError(getMessages().getMessage("User_confirmnewpassword_does_not_match"), "newPassword");
		}
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
