package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class UserRoleAddPage extends ReturnableProtectedBasePage {
	// static private final Log LOG = LogFactory.getLog(UserRoleAddPage.class);
	static public final String PAGE_NAME = "pages/security/UserRoleAddPage";

	@Persist("client:form")
	public abstract UserRole getUserRole();
	public abstract void setUserRole(UserRole value);

	@Persist("session")
	// Probably best not to use client persistence, even though it encodes the
	// field, because User includes password
	public abstract User getUser();
	public abstract void setUser(User value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getUsersModel();
	public abstract void setUsersModel(IPropertySelectionModel value);

	@Persist("client:form")
	public abstract Role getRole();
	public abstract void setRole(Role value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getRolesModel();
	public abstract void setRolesModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	public void activate(Long userId, Long roleId) throws BusinessException {

		// Use the parent's details

		ISecurityFinderSvcLocal securityFinder1 = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		User user = securityFinder1.findUserShallowish(userId);

		ISecurityFinderSvcLocal securityFinder2 = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		Role role = securityFinder2.findRoleShallowish(roleId);

		activate(user, role);
	}

	public void activate(User user, Role role) throws BusinessException {
		setUserRole(new UserRole());

		// Parent - save it and if it's null then put a selection list of users
		// onto the page

		setUser(user);

		if (user == null) {
			ISecurityFinderSvcLocal securityFinder1 = getBusinessServicesLocator().getSecurityFinderSvcLocal();
			List<User> users = securityFinder1.findUsersShallowish();
			IPropertySelectionModel m1 = new ObjectPropertySelectionModel(users, User.class, "getLoginId", null, false,
					"");
			setUsersModel(m1);
		}
		else {
			setUsersModel(null);
		}

		// Parent - save it and if it's null then put a selection list of roles
		// onto the page

		setRole(role);

		if (role == null) {
			ISecurityFinderSvcLocal securityFinder2 = getBusinessServicesLocator().getSecurityFinderSvcLocal();
			List<Role> roles = securityFinder2.findRolesShallowish();
			IPropertySelectionModel m2 = new ObjectPropertySelectionModel(roles, Role.class, "getName", null, false, "");
			setRolesModel(m2);
		}
		else {
			setRolesModel(null);
		}

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder3 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search3 = new CodeSearchFields();
		search3.setCodeGroupId(CodeGroup.ID_USERROLE_STATUS);
		search3.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder3.findCodesShallowish(search3, new SearchOptions());
		IPropertySelectionModel m3 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m3);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Add the UserRole

					UserRole userRole = getUserRole();
					Long userId = getUser().getId();
					Long roleId = getRole().getId();
					manager.addUserRole(userRole, userId, roleId);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForAdd(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
