package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.IPropertySelectionModel;

public abstract class UserRoleEditPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG = LogFactory.getLog(UserRoleEditPage.class);
	static public final String PAGE_NAME = "pages/security/UserRoleEditPage";

	@Persist("client:form")
	public abstract Long getUserRoleId();
	public abstract void setUserRoleId(Long value);

	@Persist("client:form")
	public abstract UserRole getUserRole();
	public abstract void setUserRole(UserRole value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getUsersModel();
	public abstract void setUsersModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getRolesModel();
	public abstract void setRolesModel(IPropertySelectionModel value);

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		try {
			this.activate((Long) parameters[0]);
		}
		catch (BusinessException e) {
			// TODO - review whether we can handle this exception better.
			// Should only occur if entity has been deleted?
			popAndActivateCallback();
		}
	}

	public void activate(Long id) throws BusinessException {
		setUserRoleId(id);

		// Get the UserRole

		ISecurityFinderSvcLocal securityFinder = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		UserRole userRole = securityFinder.findUserRoleShallowish(id);
		setUserRole(userRole);

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_USERROLE_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", null,
				false, "");
		setStatusesModel(m1);

		getRequestCycle().activate(this);
	}

	public ILink doSave() {
		ILink redirectTo = null;

		if (!hasErrors()) {
			validateSave();

			if (!hasErrors()) {
				try {
					ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();

					// Change the UserRole

					UserRole userRole = getUserRole();
					manager.changeUserRole(userRole);

					redirectTo = popCallbackLink();
				}
				catch (Exception e) {
					handleBusinessServicesExceptionForChange(e);
				}
			}
		}

		return redirectTo;
	}

	private void validateSave() {
		// if (xyz) {
		// recordError(getMessages().getMessage("Xyz_error"));
		// }
	}

	public void doCancel() {
		popAndActivateCallback();
	}

}
