package jumpstart.max.web.pages.security;

import java.util.List;

import jumpstart.max.business.commons.exception.BusinessException;
import jumpstart.max.business.commons.query.SearchOptions;
import jumpstart.max.business.domain.reference.Code;
import jumpstart.max.business.domain.reference.CodeGroup;
import jumpstart.max.business.domain.reference.iface.CodeSearchFields;
import jumpstart.max.business.domain.reference.iface.IReferenceFinderSvcLocal;
import jumpstart.max.business.domain.security.Role;
import jumpstart.max.business.domain.security.User;
import jumpstart.max.business.domain.security.UserRole;
import jumpstart.max.business.domain.security.iface.ISecurityFinderSvcLocal;
import jumpstart.max.business.domain.security.iface.ISecurityManagerSvcLocal;
import jumpstart.max.business.domain.security.iface.UserRoleSearchFields;
import jumpstart.max.web.commons.form.ObjectPropertySelectionModel;
import jumpstart.max.web.pages.base.ReturnableProtectedBasePage;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.form.IPropertySelectionModel;

/**
 * Page class for the application's List${entityBean.Name} page.
 * 
 * @author Geoff Callender JumpStart
 * @version $Revision: 1.10 $, $Date: 2006/02/15 10:43:06 $
 */
public abstract class UserRoleSearchPage extends ReturnableProtectedBasePage implements IExternalPage {
	// static private final Log LOG =
	// LogFactory.getLog(UserRoleSearchPage.class);
	static public final String PAGE_NAME = "pages/security/UserRoleSearchPage";

	@Persist("client:form")
	public abstract UserRoleSearchFields getSearch();
	public abstract void setSearch(UserRoleSearchFields value);

	@Persist("client")
	// Don't use client:form because DirectLinks won't return it
	public abstract UserRoleSearchFields getLastSearch();
	public abstract void setLastSearch(UserRoleSearchFields value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getStatusesModel();
	public abstract void setStatusesModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getUsersModel();
	public abstract void setUsersModel(IPropertySelectionModel value);

	@Persist("session")
	// Cannot use client persistence because not serializable
	public abstract IPropertySelectionModel getRolesModel();
	public abstract void setRolesModel(IPropertySelectionModel value);

	@Persist("session")
	// Don't use client:form because DirectLinks won't return it
	// Don't use client because the list will be stored in every link on page
	public abstract List<UserRole> getUserRoles();
	public abstract void setUserRoles(List<UserRole> value);

	public abstract UserRole getUserRole();
	public abstract void setUserRole(UserRole value);

	@Bean
	public abstract EvenOdd getEvenOdd();

	/*
	 * This method is used by callbacks - see ReturnableProtectedBasePage.popAndActivateCallback().
	 */
	public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
		this.activate((UserRoleSearchFields) parameters[0]);
	}

	public void activate() {
		doResetSearch();

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	private void activate(UserRoleSearchFields searchFields) {

		if (searchFields == null) {
			// Assume we're being called back so don't call doResetSearch()
			// because it would
			// unnecessarily refresh the selection lists
			setLastSearch(null);
			setSearch(new UserRoleSearchFields());
		}
		else {
			doSearch(searchFields);
			setSearch(searchFields);
			setLastSearch(searchFields);
		}

		getRequestCycle().activate(this);
		clearCallbacks();
	}

	public void doResetSearch() {
		setSearch(new UserRoleSearchFields());
		setLastSearch(null);
		setUserRoles(null);
		refreshSelectionLists();
	}

	public void refreshSelectionLists() {

		// Put a selection list of statuses onto the page

		IReferenceFinderSvcLocal referenceFinder1 = getBusinessServicesLocator().getReferenceFinderSvcLocal();
		CodeSearchFields search1 = new CodeSearchFields();
		search1.setCodeGroupId(CodeGroup.ID_USERROLE_STATUS);
		search1.setStatusId(Code.ID_CODE_STATUS_ACTIVE);
		List<Code> statuses = referenceFinder1.findCodesShallowish(search1, new SearchOptions());
		IPropertySelectionModel m1 = new ObjectPropertySelectionModel(statuses, Code.class, "getDescription", "getId",
				true, null);
		setStatusesModel(m1);

		// Put a selection list of users onto the page

		ISecurityFinderSvcLocal securityFinder2 = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		List<User> users = securityFinder2.findUsersShallowish();
		IPropertySelectionModel m2 = new ObjectPropertySelectionModel(users, User.class, "getLoginId", "getId", true,
				null);
		setUsersModel(m2);

		// Put a selection list of roles onto the page

		ISecurityFinderSvcLocal securityFinder3 = getBusinessServicesLocator().getSecurityFinderSvcLocal();
		List<Role> roles = securityFinder3.findRolesShallowish();
		IPropertySelectionModel m3 = new ObjectPropertySelectionModel(roles, Role.class, "getName", "getId", true, null);
		setRolesModel(m3);
	}

	public void doSearch(UserRoleSearchFields searchFields) {

		if (!hasErrors()) {
			ISecurityFinderSvcLocal finder = getBusinessServicesLocator().getSecurityFinderSvcLocal();

			SearchOptions searchOptions = new SearchOptions();
			List<UserRole> l = finder.findUserRolesShallowish(searchFields, searchOptions);
			setUserRoles(l);

			setLastSearch(searchFields);
		}
	}

	public void doNew() {

		try {
			User user = null;
			Role role = null;
			UserRoleAddPage nextPage = (UserRoleAddPage) getRequestCycle().getPage(UserRoleAddPage.PAGE_NAME);
			nextPage.activate(user, role);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doView(Long id) {

		try {
			UserRoleViewPage nextPage = (UserRoleViewPage) getRequestCycle().getPage(UserRoleViewPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doEdit(Long id) {

		try {
			UserRoleEditPage nextPage = (UserRoleEditPage) getRequestCycle().getPage(UserRoleEditPage.PAGE_NAME);
			nextPage.activate(id);

			pushExternalCallback(this, new Object[] { getLastSearch() });
		}
		catch (BusinessException e) {
			recordError(e.toString());
		}

	}

	public void doRemove(Long id) {

		if (!hasErrors()) {

			// Find the UserRole in the list by id

			UserRole userRole = null;
			for (UserRole userRole1 : getUserRoles()) {
				if (userRole1.getId().equals(id)) {
					userRole = userRole1;
					break;
				}
			}

			// If not there it will be because Reload chosen after removing
			// it, so just return
			if (userRole == null) {
				return;
			}

			try {
				// Delete the UserRole

				ISecurityManagerSvcLocal manager = getBusinessServicesLocator().getSecurityManagerSvcLocal();
				manager.removeUserRole(userRole);

				// Update the userRoles list on screen

				List<UserRole> userRoles = getUserRoles();
				userRoles.remove(userRole);
				setUserRoles(userRoles);
			}
			catch (Exception e) {
				handleBusinessServicesExceptionForRemove(e);
			}
		}

	}

}
